<?php

namespace Elementor;
if (!defined('ABSPATH')) exit;

use \ElementsKit_Lite\Modules\Controls\Controls_Manager as ElementsKit_Controls_Manager;

class Qoxag_Title extends Widget_Base
{

    public $base;

    public function get_name()
    {
        return 'title';
    }

    public function get_title()
    {

        return esc_html__('Qoxag Title', 'qoxag');

    }

    public function get_icon()
    {
        return 'eicon-site-title';
    }

    public function get_categories()
    {
        return ['qoxag-elements'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Title settings', 'qoxag'),
            ]
        );
        if(class_exists('ElementsKit_Lite')){
        $this->add_control(
            'title_style',
            [
                'label' => esc_html__( 'Title style', 'qoxag' ),
                'type' => ElementsKit_Controls_Manager::IMAGECHOOSE,
                'default' => 'style1',
                'options' => [
                    'style1'  => [
                        'title' => esc_html__( 'Style 1', 'qoxag' ),
                        'imagelarge' => QOXAG_IMG. '/style/title/style1.png',
                        'imagesmall' => QOXAG_IMG. '/style/title/style1.png',
                        'width' => '30%',
                    ],
                ],
            ]
        );
        } else {
            $this->add_control(
                'title_style',
                [
                    'label' => esc_html__( 'Title style', 'qoxag' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'style1',
                    'options' => [
                        'style1'  => esc_html__( 'Style 1', 'qoxag' ),
                    ],
                ]
            );
        }

        $this->add_control(
            'heading_title',
            [
                'label' => __( 'Heading Title', 'qoxag' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Section title', 'qoxag' ),
                'placeholder' => __( 'Type your title here', 'qoxag' ),
            ]
        );

        $this->add_control(
            'heading_title_tag',
            [
                'label' => esc_html__( 'Title HTML Tag', 'qoxag' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h2',
            ]
        );

        $this->add_control( 'show_shadow_text', [
            'label' => esc_html__( 'Show Shadow Text', 'qoxag' ),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
        ]);

        $this->add_control(
            'shadow_text',
            [
                'label' => __( 'Shadow Text', 'qoxag' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Section shadow text', 'qoxag' ),
                'placeholder' => __( 'Type your title here', 'qoxag' ),
                'condition' => [
                    'show_shadow_text' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'show_seperator', [
                'label'			 =>esc_html__( 'Show separator', 'qoxag' ),
                'type'			 => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' =>esc_html__( 'Yes', 'qoxag' ),
                'label_off' =>esc_html__( 'No', 'qoxag' ),
            ]

        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_title_style', [
                'label'	 => esc_html__( 'Title', 'qoxag' ),
                'tab'	 => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color', [
                'label'		 => esc_html__( 'Title color', 'qoxag' ),
                'type'		 => Controls_Manager::COLOR,
                'default'    => '#202020',
                'selectors'	 => [
                    '{{WRAPPER}} .section-title' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'		 => 'title_typography',
                'selector'	 => '{{WRAPPER}} .section-title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '38',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '32',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__( 'Title Margin', 'qoxag' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_separator_color', [
                'label'		 =>esc_html__( 'Title Separator Color', 'qoxag' ),
                'type'		 => Controls_Manager::COLOR,
                'default'    => '#7070703B',
                'selectors'	 => [
                    '{{WRAPPER}} .section-title .divider::after' => 'background: {{VALUE}};',
                ]
            ]
        );

        $this->add_responsive_control(
            'title_seperator_height',
            [
                'label' => esc_html__( 'Separator Height', 'qoxag' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .section-title .divider::after' => 'height: {{SIZE}}{{UNIT}};',
                ]
            ]
        );

        $this->add_responsive_control(
            'title_background_width',
            [
                'label' => esc_html__('Title background Width', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 250,
                ],
                'selectors' => [
                    '{{WRAPPER}} .section-title::before' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_background_color', [
                'label'		 => esc_html__( 'Title BG Color', 'qoxag' ),
                'type'		 => Controls_Manager::COLOR,
                'default'    => '#fff',
                'selectors'	 => [
                    '{{WRAPPER}} .qoxag-title .section-title::before' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'shadow_text_style', [
                'label'	 => esc_html__( 'Shadow Text', 'qoxag' ),
                'tab'	 => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_shadow_text' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'shadow_text_color', [
                'label'		 => esc_html__( 'Color', 'qoxag' ),
                'type'		 => Controls_Manager::COLOR,
                'default'    => '#E7E7EB',
                'selectors'	 => [
                    '{{WRAPPER}} .section-subtitle' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'		 => 'shadow_text_typography',
                'selector'	 => '{{WRAPPER}} .section-subtitle',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '48',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '32',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'shadow_text_margin',
            [
                'label' => esc_html__( 'Margin', 'qoxag' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '-10',
                    'left' => '20',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .section-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        //separator Style Section
        $this->start_controls_section(
            'separator_style', [
                'label'	 => esc_html__( 'Separator', 'qoxag' ),
                'tab'	 => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_seperator' => 'yes'
                ]
            ]
        );
        $this->add_responsive_control(
            'seperator_color', [
                'label'		 =>esc_html__( 'separator color', 'qoxag' ),
                'type'		 => Controls_Manager::COLOR,
                'default'    => '#11FFF7',
                'selectors'	 => [
                    '{{WRAPPER}} .separetor_wrapper .border-divider' => 'background: linear-gradient(90deg, {{VALUE}} 0%, {{VALUE}} 100%);',
                ]
            ]
        );
        $this->add_responsive_control(
            'seperator_width',
            [
                'label' => esc_html__( 'Width', 'qoxag' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .separetor_wrapper .border-divider' => 'width: {{SIZE}}{{UNIT}};'
                ],
            ]
        );

        $this->add_responsive_control(
            'seperator_height',
            [
                'label' => esc_html__( 'Height', 'qoxag' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .separetor_wrapper .border-divider' => 'height: {{SIZE}}{{UNIT}};',
                ]
            ]
        );

        $this->add_responsive_control(
            'seperator_position',
            [
                'label' => esc_html__( 'Position From left', 'qoxag' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .section-title::before' => 'left: {{SIZE}}{{UNIT}};'
                ],
            ]
        );

        $this->add_responsive_control(
            'seperator_position_top',
            [
                'label' => esc_html__( 'Position From top', 'qoxag' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-title .section-title .divider::after' => 'top: {{SIZE}}{{UNIT}};'
                ],
            ]
        );

        $this->add_responsive_control(
            'seperator_margin',
            [
                'label' => esc_html__( 'Margin', 'qoxag' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'default' => [
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .separetor_wrapper .border-divider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'seperator_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'qoxag' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'default' => [
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .separetor_wrapper .border-divider' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }

    protected function content_template()
    {
    }
}